<?php
require_once 'dbconfig.php';
header('Content-Type: application/json');

$db = getDBConnection();
$data = json_decode(file_get_contents('php://input'), true);

$siteid = $db->real_escape_string($data['siteid']);
$slotid = intval($data['slotid']);
$port = intval($data['port']);
$fdt_code = $db->real_escape_string($data['fdt_code']);
$update_by = isset($data['update_by']) ? $db->real_escape_string($data['update_by']) : 'unknown';

$port_col = 'port' . $port;
$log_port = $port + 1; // Selalu gunakan ini untuk log

// Cek apakah data sudah ada
$result = $db->query("SELECT * FROM port_management_olt WHERE siteid = '$siteid' AND slotid = $slotid");

if ($result->num_rows === 0) {
    // Insert baru
    $columns = ['siteid', 'slotid', 'update_by'];
    $values = ["'$siteid'", $slotid, "'$update_by'"];

    for ($i = 1; $i <= 16; $i++) {
        $columns[] = "port$i";
        $values[] = $i == $log_port ? "'$fdt_code'" : "'Unused'";
    }

    $query = "INSERT INTO port_management_olt (".implode(',', $columns).") VALUES (".implode(',', $values).")";
    $db->query($query);

    // Catat ke log
    $unused = "Unused";
    $log_stmt = $db->prepare("INSERT INTO port_logs (siteid, slotid, port, old_value, new_value, update_by) VALUES (?, ?, ?, ?, ?, ?)");
    $log_stmt->bind_param("siisss", $siteid, $slotid, $log_port, $unused, $fdt_code, $update_by);
    $log_stmt->execute();

} else {
    // Update port lama
    $row = $result->fetch_assoc();
    $old_value = $row[$port_col];

    $query = "UPDATE port_management_olt SET $port_col = '$fdt_code', update_by = '$update_by' WHERE siteid = '$siteid' AND slotid = $slotid";
    $db->query($query);

    // Catat ke log hanya jika terjadi perubahan
    if ($old_value !== $fdt_code) {
        $log_stmt = $db->prepare("INSERT INTO port_logs (siteid, slotid, port, old_value, new_value, update_by) VALUES (?, ?, ?, ?, ?, ?)");
        $log_stmt->bind_param("siisss", $siteid, $slotid, $log_port, $old_value, $fdt_code, $update_by);
        $log_stmt->execute();
    }
}

if ($db->error) {
    echo json_encode(['success' => false, 'error' => $db->error]);
} else {
    echo json_encode(['success' => true]);
}

$db->close();
?>
