<?php  
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}
$loggedInUser = $_SESSION['user'];
$fullName = $_SESSION['full_name'] ?? $loggedInUser;
require_once 'dbconfig.php'; 
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OLT Port Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet.fullscreen@2.4.0/Control.FullScreen.min.css" />
        <link rel="stylesheet" href="gaya_olt.css">
 
</head>
<body>

<!-- Modify the container div -->
<div class="container-fluid py-3">
    <div class="row mb-4 justify-content-center"> 
    <!-- Added justify-content-center -->
    <div class="col-md-5">
        <h5>OLT Port Management</h5>
    </div>

    <div class="row mb-3 justify-content-center"> 
    <!-- Added justify-content-center -->
    <div class="col-md-5">  <!-- Changed from col-md-3 to col-md-5 -->
        <select class="form-select select2" id="citySelect" style="max-width: 100%">  <!-- Added max-width -->
            <option value="">Select City</option>
            <?php
            $db = getDBConnection();
            $cities = $db->query("SELECT DISTINCT kota FROM assetdata WHERE jenis2 = 'MICRO' ORDER BY kota");
            while ($city = $cities->fetch_assoc()) {
                echo '<option value="'.htmlspecialchars($city['kota']).'">'
                    .htmlspecialchars($city['kota']).'</option>';
            }
            $db->close();
            ?>
        </select>
    </div>
    <div class="col-md-5">  <!-- Changed from col-md-3 to col-md-5 -->
        <select class="form-select select2" id="siteSelect" disabled style="max-width: 100%">  <!-- Added max-width -->
            <option value="">Select OLT Site</option>
        </select>
    </div>
</div>

    <!-- Changed this div to use olt-container-a4 class -->
    <div class="olt-container-a4 card mb-3" id="oltContainer" style="display:none;">
        <div class="card-body p-3">
            <h6 id="oltTitle" class="mb-3"></h6>
            <div class="d-flex flex-wrap"> <!-- Changed to flex-wrap for better responsiveness -->
                <!-- Slot Container (left side) -->
                <div class="slot-container" id="slotContainer"></div>
                
                <!-- Right side container (summary and map) -->
                <div class="d-flex flex-column ms-3" style="min-width: 180px;">
                    <!-- Port Summary & Information Card --> <br> <br> <br>
                    <div class="card mb-3">
                        <div class="card-header bg-primary text-white py-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="mb-0" style="font-size: 0.9rem;">Document Information</h6>
                                <small id="portType" style="font-size: 0.75rem;">HUAWEI 0-15</small>
                            </div>
                        </div>
                        
                        <div class="card-body p-2">
                           

                            <!-- Information Section -->
                            <div class="border-top pt-2">
                                <div class="d-flex justify-content-between align-items-start mb-2">
                                    <div style="width: 45%;">
                                        <small class="text-muted" style="font-size: 0.75rem; font-weight: 500;">LAST MODIFIED</small>
                                    </div>
                                    <div style="width: 55%; text-align: right;">
                                        <div id="lastModifiedDate" style="font-size: 0.8rem; font-weight: 500;">Loading...</div>
                                        <div id="lastModifiedBy" style="font-size: 0.75rem; color: #6c757d;">Loading...</div>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between align-items-start mb-2">
                                    <div style="width: 45%;">
                                        <small class="text-muted" style="font-size: 0.75rem; font-weight: 500;">RELEASE INFO</small>
                                    </div>
                                    <div style="width: 55%; text-align: right;">
                                        <div id="releaseDate" style="font-size: 0.8rem; font-weight: 500;"><?php
date_default_timezone_set('Asia/Jakarta');
echo date('Y-m-d');
?></div>
                                        <div id="releaseBy" style="font-size: 0.75rem; color: #6c757d;"><?php echo htmlspecialchars($fullName); ?></div>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between align-items-center pt-2" style="border-top: 1px solid #dee2e6;">
                                    <div style="width: 45%;">
                                        <small class="text-muted" style="font-size: 0.75rem; font-weight: 500;">INDEX DRAWING</small>
                                    </div>
                                    <div style="width: 55%; text-align: right;">
                                        <div id="indexDrawing" style="font-size: 0.8rem; font-weight: 500; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;" title="Loading...">Loading...</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
 
                  <div class="card mb-3">
                        <div class="card-header bg-primary text-white py-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="mb-0" style="font-size: 0.9rem;">Port Summary</h6>
                                <small id="portType" style="font-size: 0.75rem;">HUAWEI 0-15</small>
                            </div>
                        </div>
                        
                        <div class="card-body p-2">
                            <!-- Summary Section -->
                            <div class="d-flex justify-content-between mb-3">
                                <div class="text-center" style="width: 23%;">
                                    <div class="border rounded p-1">
                                        <small class="text-muted d-block" style="font-size: 0.65rem;">Total</small>
                                        <h5 id="totalPorts" class="mb-0" style="font-size: 0.9rem;">0</h5>
                                        <small class="text-muted d-block" id="portTypeBadge" style="font-size: 0.6rem;">HUAWEI</small>
                                    </div>
                                </div>
                                <div class="text-center" style="width: 23%;">
                                    <div class="border rounded p-1">
                                        <small class="text-success d-block" style="font-size: 0.65rem;">RFS</small>
                                        <h5 id="rfsPorts" class="mb-0" style="font-size: 0.9rem;">0</h5>
                                    
                                    </div>
                                </div>
                                <div class="text-center" style="width: 23%;">
                                    <div class="border rounded p-1">
                                        <small class="text-warning d-block" style="font-size: 0.65rem;">Non-RFS</small>
                                        <h5 id="nonRfsPorts" class="mb-0" style="font-size: 0.9rem;">0</h5>
                                   
                                    </div>
                                </div>
                                <div class="text-center" style="width: 23%;">
                                    <div class="border rounded p-1">
                                        <small class="text-secondary d-block" style="font-size: 0.65rem;">Available</small>
                                        <h5 id="unusedPorts" class="mb-0" style="font-size: 0.9rem;">0</h5>
                                      
                                    </div>
                                </div>
                            </div>
 <div class="card-header bg-primary text-white py-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="mb-0" style="font-size: 0.9rem;">Legend</h6>
                                <small id="portType" style="font-size: 0.75rem;">HUAWEI 0-15</small>
                            </div>
                        </div>
                        
                            <div class="border-top pt-2 mb-3">
    <div class="row">
        <div class="col-6">
            <div class="d-flex align-items-center mb-1">
                <span class="port-rect RFS me-1" style="width: 16px; height: 10px;"></span>
                <small style="font-size: 0.65rem;">RFS</small>
            </div>
            <div class="d-flex align-items-center mb-1">
                <span class="port-rect Construction me-1" style="width: 16px; height: 10px;"></span>
                <small style="font-size: 0.65rem;">Construction</small>
            </div>
            <div class="d-flex align-items-center mb-1">
                <span class="port-rect Design me-1" style="width: 16px; height: 10px;"></span>
                <small style="font-size: 0.65rem;">Design</small>
            </div>
            <div class="d-flex align-items-center mb-1">
                <span class="port-rect Planning me-1" style="width: 16px; height: 10px;"></span>
                <small style="font-size: 0.65rem;">Planning</small>
            </div>
            <div class="d-flex align-items-center mb-1">
                <span class="port-rect Unused me-1" style="width: 16px; height: 10px;"></span>
                <small style="font-size: 0.65rem;">Available</small>
            </div>
        </div>
        <div class="col-6 text-center">
            <!-- Logo dari URL -->
            <img src="https://www.linknet.co.id/files/logo-ln-terbaru.png" 
             style="max-height: 80px; max-width: 100%; object-fit: contain;">
           
        </div>
    </div>
</div>
                        </div>
                    </div>
                </div>
            </div>
            <br>
              <!-- OLT Location Map -->
                    <div class="card">
                        <div class="card-header py-2">
                             <h6 class="mb-0" style="font-size: 0.9rem;">OLT Location</h6>
                        </div>
                        <div class="card-body p-0">
                            <div id="oltMap" style="height: 300px;"></div>
                        </div>
                    </div>
        </div>
        
    </div>
</div>

<!-- Modal Edit Port -->
<div class="modal fade" id="portModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalTitle">Port Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="portForm">
            <input type="hidden" id="modalSiteId">
            <input type="hidden" id="modalSlotId">
            <input type="hidden" id="modalPortNum">
            <div class="mb-3">
                <label class="form-label">OLT Merk</label>
                <input type="text" class="form-control" id="modalOltMerk" readonly>
            </div>
            <div class="mb-3">
                <label class="form-label">FDT</label>
                <input type="text" class="form-control" id="modalFdtCode" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Updated By</label>
               <input type="text" class="form-control" id="modalUpdateBy" value="<?= htmlspecialchars($loggedInUser) ?>" readonly>
            </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger me-auto" id="deletePortBtn">Delete</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary" id="savePortBtn">Save</button>
      </div>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/leaflet.fullscreen@2.4.0/Control.FullScreen.min.js"></script>


<script>
    // Global variables
    let currentSite = '';
    let currentSlot = 0;
    let currentPort = 0;
    const portModal = new bootstrap.Modal('#portModal');
    let oltMap = null;
    let mapMarker = null;
    
    // Initialize Select2 dropdowns
    $(document).ready(function() {
        $('#citySelect').select2({
            placeholder: "Select City",
            allowClear: true,
            width: '100%'
        });
        
        $('#siteSelect').select2({
            placeholder: "Select OLT Site",
            allowClear: true,
            width: '100%'
        });
    });
    
    // Initialize event listeners
    $('#citySelect').on('change', loadOLTSites);
    $('#siteSelect').on('change', loadOLT);
    document.getElementById('savePortBtn').addEventListener('click', savePort);
    document.getElementById('deletePortBtn').addEventListener('click', deletePort);
    
    // Load OLT sites based on selected city
    function loadOLTSites() {
        const city = this.value;
        const siteSelect = $('#siteSelect');
        
        if (!city) {
            siteSelect.prop('disabled', true).val('').trigger('change');
            $('#oltContainer').hide();
            return;
        }
        
        // Show loading state
        siteSelect.prop('disabled', true).html('<option value="">Loading...</option>');
        
        fetch(`get_olts.php?city=${encodeURIComponent(city)}`)
            .then(response => response.json())
            .then(data => {
                siteSelect.empty().append('<option value="">Select OLT Site</option>');
                
                data.forEach(olt => {
                    const option = new Option(olt.siteid, olt.siteid);
                    $(option).data('status', olt.status || 'Unused')
                            .data('merk', olt.merk || 'Unknown');
                    siteSelect.append(option);
                });
                
                siteSelect.prop('disabled', false).trigger('change');
            })
            .catch(error => {
                console.error('Error loading OLTs:', error);
                siteSelect.empty().append('<option value="">Error loading data</option>');
            });
    }
    
    // Load OLT data
    async function loadOLT() {
        currentSite = this.value;
        const selectedOption = $(this).find('option:selected');
        const siteStatus = selectedOption.data('status') || 'Unused';
        const siteMerk = selectedOption.data('merk') || 'Unknown';
        
        if (!currentSite) {
            document.getElementById('oltContainer').style.display = 'none';
            return;
        }
        
        // Update title
        document.getElementById('oltTitle').innerHTML = `
            <span class="fdt-badge ${siteStatus}">${currentSite}</span>
            <span class="fdt-badge ${siteStatus}">${siteMerk}</span>
        `;
        document.getElementById('oltContainer').style.display = 'block';
        
        try {
            const response = await fetch(`get_slots_olt.php?siteid=${encodeURIComponent(currentSite)}`);
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            
            const data = await response.json();
            
            if (!data.success) {
                throw new Error(data.error || 'Failed to load OLT data');
            }
            
            renderSlots(data.slots, data.stats.merk);
            updateSummaryCard(data.stats);
            
            // Load location data separately
            try {
                const locationResponse = await fetch(`get_location.php?siteid=${encodeURIComponent(currentSite)}`);
                if (locationResponse.ok) {
                    const locationData = await locationResponse.json();
                    showMap(locationData);
                }
            } catch (locationError) {
                console.error('Error loading location:', locationError);
            }
            
        } catch (error) {
            console.error('Error loading OLT:', error);
            alert('Error loading OLT data: ' + error.message);
        }
        loadModificationData();
    }

    function renderSlots(slotsData, merk) {
        const slotContainer = document.getElementById('slotContainer');
        slotContainer.innerHTML = '';

        const slotNumbers = Object.keys(slotsData).map(Number).sort((a, b) => a - b);
        
        if (slotNumbers.length === 0) {
            slotContainer.innerHTML = '<div class="alert alert-info">No slots found for this OLT</div>';
            return;
        }

        // Determine port range based on merk
        const portRange = (merk === 'ZTE') ? 
            Array.from({length: 16}, (_, i) => i + 1) : // ZTE: 1-16
            Array.from({length: 16}, (_, i) => i);     // HUAWEI: 0-15

        slotNumbers.forEach(slotNum => {
            const slotDiv = document.createElement('div');
            slotDiv.className = 'slot-wrapper';
            
            const slotHeader = document.createElement('div');
            slotHeader.className = 'slot-header';
            slotHeader.textContent = `Slot ${slotNum}`;
            slotDiv.appendChild(slotHeader);

            const portColumns = document.createElement('div');
            portColumns.className = 'port-columns';
            
            const column1 = document.createElement('div');
            column1.className = 'port-column';
            const column2 = document.createElement('div');
            column2.className = 'port-column';
            
            portColumns.appendChild(column1);
            portColumns.appendChild(column2);
            slotDiv.appendChild(portColumns);
            
            const slotData = slotsData[slotNum];
            const halfPorts = Math.ceil(portRange.length / 2);

            portRange.forEach((portNum, index) => {
                const portKey = `port${portNum}`;
                const statusKey = `status${portNum}`;
                const portValue = slotData[portKey] || 'Unused';
                const status = slotData[statusKey] || 'Unused';
                const isUsed = portValue !== 'Unused';

                const portDiv = document.createElement('div');
                portDiv.className = `port-item ${isUsed ? 'port-used' : 'port-unused'}`;
                portDiv.innerHTML = `
                    <div class="port-circle">${portNum}</div>
                    <div class="port-info">
                        <div class="fdt-badge ${status}">${portValue}</div>
                    </div>
                `;

                portDiv.addEventListener('click', () => {
                    selectPort(slotNum, portNum);
                });

                (index < halfPorts ? column1 : column2).appendChild(portDiv);
            });

            slotContainer.appendChild(slotDiv);
        });
    }

    function updateSummaryCard(stats) {
        const total = stats.total || 0;
        const rfs = stats.rfs || 0;
        const nonRfs = stats.non_rfs || 0;
        const unused = stats.unused || 0;
        const merk = stats.merk || 'HUAWEI';
        
        // Update counts
        document.getElementById('totalPorts').textContent = total;
        document.getElementById('rfsPorts').textContent = rfs;
        document.getElementById('nonRfsPorts').textContent = nonRfs;
        document.getElementById('unusedPorts').textContent = unused;
        document.getElementById('portType').textContent = `${merk} ${merk === 'ZTE' ? '1-16' : '0-15'}`;
        document.getElementById('portTypeBadge').textContent = merk;
        
    }
    
   function showMap(locationData) {
    // Pastikan container peta ada
    if (!document.getElementById('oltMap')) {
        console.error('Map container not found');
        return;
    }

    // Inisialisasi peta jika belum ada
     if (!oltMap) {
        oltMap = L.map('oltMap', {
            zoomControl: false, 
            scrollWheelZoom: true // Memastikan zoom dengan mouse tetap aktif
        }).setView([-2.5489, 118.0149], 5);
        
        L.tileLayer('https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png', {
            
        }).addTo(oltMap);
        
        // Tambahkan kontrol fullscreen
        oltMap.addControl(new L.Control.FullScreen({
            title: {
                'false': 'View Fullscreen',
                'true': 'Exit Fullscreen'
            },
            position: 'topright'
        }));
    }

    // Validasi data lokasi
    if (!locationData || !locationData.lat || !locationData.lng) {
        console.error('Invalid location data:', locationData);
        alert('Lokasi OLT tidak ditemukan dalam database');
        return;
    }

    const lat = parseFloat(locationData.lat);
    const lng = parseFloat(locationData.lng);

    // Validasi koordinat
    if (isNaN(lat) || isNaN(lng)) {
        console.error('Invalid coordinates:', locationData);
        return;
    }

    const latLng = [lat, lng];

    // Hapus marker lama jika ada
    if (mapMarker) {
        oltMap.removeLayer(mapMarker);
    }

    // Buat marker baru
    mapMarker = L.marker(latLng).addTo(oltMap)
        .bindPopup(`<b>${currentSite}</b>`)
        .openPopup();

    // Set view ke lokasi marker
    oltMap.setView(latLng, 15);
}

   async function selectPort(slotNum, portNum) {
        currentSlot = slotNum;
        currentPort = portNum;
        
        const selectedOption = $('#siteSelect').find('option:selected');
        const siteMerk = selectedOption.data('merk') || 'HUAWEI';
        
        // Validate port number based on merk
        let minPort, maxPort;
        if (siteMerk === 'ZTE') {
            minPort = 1; maxPort = 16;
        } else { // Huawei
            minPort = 0; maxPort = 15;
        }
        
        if (portNum < minPort || portNum > maxPort) {
            alert(`Invalid port number for ${siteMerk}. Valid range: ${minPort}-${maxPort}`);
            return;
        }
        
        try {
            const response = await fetch(`get_port.php?siteid=${currentSite}&slotid=${slotNum}&port=${portNum}&merk=${siteMerk}`);
            const portData = await response.json();
            
            document.getElementById('modalTitle').textContent = 
                `${siteMerk} Port ${portNum} - Slot ${slotNum}`;
            document.getElementById('modalSiteId').value = currentSite;
            document.getElementById('modalSlotId').value = slotNum;
            document.getElementById('modalPortNum').value = portNum;
            document.getElementById('modalOltMerk').value = siteMerk;
            document.getElementById('modalFdtCode').value = portData.fdt_code || '';
            
            portModal.show();
        } catch (error) {
            console.error('Error loading port:', error);
            alert(`Error loading port details: ${error.message}`);
        }
    }
    
    async function savePort() {
        const portData = {
            siteid: document.getElementById('modalSiteId').value,
            slotid: parseInt(document.getElementById('modalSlotId').value),
            port: parseInt(document.getElementById('modalPortNum').value),
            fdt_code: document.getElementById('modalFdtCode').value,
            update_by: document.getElementById('modalUpdateBy').value,
            merk: document.getElementById('modalOltMerk').value
        };

        console.log('Sending:', portData);

        try {
            const response = await fetch('update_port.php', {
                method: 'POST',
                headers: { 
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(portData)
            });

            // First check if response is JSON
            const text = await response.text();
            let result;
            try {
                result = JSON.parse(text);
            } catch (e) {
                throw new Error(`Invalid JSON response: ${text}`);
            }

            console.log('Received:', result);

            if (!response.ok) {
                throw new Error(result.error || `Server error: ${response.status}`);
            }

            if (result.success) {
                portModal.hide();
                loadOLT.call({ value: currentSite });
                alert('Port updated successfully!');
            } else {
                throw new Error(result.error || 'Failed to save port');
            }
        } catch (error) {
            console.error('Full error:', error);
            alert(`Error: ${error.message}`);
        }
    }

    async function deletePort() {
        if (!confirm('Are you sure you want to reset this port to Unused status?')) {
            return;
        }

        const portData = {
            siteid: document.getElementById('modalSiteId').value,
            slotid: document.getElementById('modalSlotId').value,
            port: document.getElementById('modalPortNum').value,
            merk: document.getElementById('modalOltMerk').value,
            update_by: document.getElementById('modalUpdateBy').value
        };

        try {
            const response = await fetch('delete_port.php', {
                method: 'POST',
                headers: { 
                    'Content-Type': 'application/json',
                    'Accept': 'application/json'
                },
                body: JSON.stringify(portData)
            });
            
            const result = await response.json();
            
            if (!response.ok) {
                throw new Error(result.error || 'Failed to reset port');
            }

            if (result.success) {
                // Show success message with OLT type info
                alert(`Success: ${result.message}\n` + 
                      `OLT Type: ${result.merk}\n` +
                      `Port Schema: ${result.port_schema}`);
                
                portModal.hide();
                loadOLT.call({ value: currentSite });
            } else {
                throw new Error(result.message || 'Failed to reset port');
            }
        } catch (error) {
            console.error('Error deleting port:', error);
            alert(`Error: ${error.message}`);
            
            // For debugging - show received data in console
            if (error.response) {
                error.response.json().then(data => {
                    console.log("Error details:", data);
                });
            }
        }
    }
    function loadModificationData() {
        if (!currentSite) {
            document.getElementById('lastModifiedDate').textContent = 'Select OLT first';
            document.getElementById('lastModifiedBy').textContent = 'N/A';
            document.getElementById('indexDrawing').textContent = 'FM_5_PF_OLT00_250000_0';
            return;
        }

        fetch('get_last_modification.php?siteid=' + encodeURIComponent(currentSite))
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    // Handle last modified by
                    document.getElementById('lastModifiedBy').textContent = data.update_by || 'N/A';
                    
                    // Handle date
                    let displayDate = 'N/A';
                    let drawingDate = '';
                    let isValidDate = false;
                    
                    if (data.updated_time && data.updated_time !== 'N/A') {
                        try {
                            const dateObj = new Date(data.updated_time);
                            if (!isNaN(dateObj.getTime())) {
                                // Format for display
                                displayDate = dateObj.toLocaleString('en-US', {
                                    year: 'numeric',
                                    month: '2-digit',
                                    day: '2-digit',
                                    hour: '2-digit',
                                    minute: '2-digit'
                                });
                                
                                // Format for drawing number (YYMMDD)
                                const year2Digit = dateObj.getFullYear().toString().slice(-2);
                                const month = String(dateObj.getMonth() + 1).padStart(2, '0');
                                const day = String(dateObj.getDate()).padStart(2, '0');
                                drawingDate = year2Digit + month + day;
                                isValidDate = true;
                            }
                        } catch (e) {
                            console.error('Date processing error:', e);
                        }
                    }
                    
                    document.getElementById('lastModifiedDate').textContent = displayDate;
                    
                    // Format site ID (first 3 + last 2 chars)
                    const formattedSiteId = currentSite.length >= 5 
                        ? currentSite.substring(0, 3) + currentSite.slice(-2)
                        : currentSite;
                    
                    // Generate drawing number - use current date if no valid date exists
                    let finalDrawingDate = drawingDate;
                    if (!isValidDate) {
                        const now = new Date();
                        const year2Digit = now.getFullYear().toString().slice(-2);
                        const month = String(now.getMonth() + 1).padStart(2, '0');
                        const day = String(now.getDate()).padStart(2, '0');
                        finalDrawingDate = year2Digit + month + day;
                    }
                    
                    const drawingNumber = `FM_5_PF_${formattedSiteId}_${finalDrawingDate}_0`;
                    document.getElementById('indexDrawing').textContent = drawingNumber;
                    document.getElementById('indexDrawing').setAttribute('title', drawingNumber);
                } else {
                    document.getElementById('lastModifiedDate').textContent = 'N/A';
                    document.getElementById('lastModifiedBy').textContent = 'N/A';
                    document.getElementById('indexDrawing').textContent = 'FM_5_PF_OLT00_250000_0';
                }
            })
            .catch(error => {
                console.error('Error loading modification data:', error);
                document.getElementById('lastModifiedDate').textContent = 'N/A';
                document.getElementById('lastModifiedBy').textContent = 'N/A';
                document.getElementById('indexDrawing').textContent = 'FM_5_PF_OLT00_250000_0';
            });
    }
    document.addEventListener('DOMContentLoaded', loadModificationData);
</script>
</body>
</html>