<?php
require_once 'dbconfig.php';

header('Content-Type: application/json');

$db = getDBConnection();
$siteid = $db->real_escape_string($_GET['siteid']);
$slotid = intval($_GET['slotid']);
$port = intval($_GET['port']);

// Get the OLT merk from assetdata for port numbering scheme
$merk = 'Unknown';
$merkQuery = $db->query("SELECT merk FROM assetdata WHERE siteid = '$siteid' LIMIT 1");
if ($merkQuery && $merkQuery->num_rows > 0) {
    $merkRow = $merkQuery->fetch_assoc();
    $merk = $merkRow['merk'] ?? 'Unknown';
}

// Determine port column based on merk
$port_col = 'port' . $port;
$log_port = in_array($merk, ['5800-X15', 'MA5600T']) ? $port + 1 : $port;

$result = $db->query("SELECT $port_col as fdt_code FROM port_management_olt WHERE siteid = '$siteid' AND slotid = $slotid");

$response = [
    'fdt_code' => '',
    'port_number' => $log_port,  // Return the display/log port number
    'merk' => $merk
];

if ($result) {
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $response['fdt_code'] = $row['fdt_code'] ?? '';
    }
} else {
    $response['error'] = $db->error;
}

echo json_encode($response);
$db->close();
?>