<?php
require_once 'dbconfig.php';
header('Content-Type: application/json');

if (!isset($_GET['siteid'])) {
    echo json_encode([
        'success' => false,
        'error' => 'Site ID not provided',
        'updated_time' => 'N/A',
        'update_by' => 'N/A'
    ]);
    exit;
}

$siteId = $_GET['siteid'];

try {
    $db = getDBConnection();
    
    $query = "SELECT updated_time, update_by 
              FROM port_management_olt 
              WHERE siteid = ? 
              AND updated_time IS NOT NULL
              AND updated_time != '0000-00-00 00:00:00'
              ORDER BY updated_time DESC 
              LIMIT 1";
              
    $stmt = $db->prepare($query);
    $stmt->bind_param('s', $siteId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $response = [
        'success' => true,
        'updated_time' => 'N/A', // Default to N/A
        'update_by' => 'N/A'     // Default to N/A
    ];

    if ($result && $row = $result->fetch_assoc()) {
        // Handle update_by (ensure it's never NULL)
        $response['update_by'] = !empty($row['update_by']) ? $row['update_by'] : 'N/A';
        
        // Handle updated_time
        if (!empty($row['updated_time']) && $row['updated_time'] != '0000-00-00 00:00:00') {
            try {
                $datetime = new DateTime($row['updated_time']);
                $response['updated_time'] = $datetime->format('Y-m-d H:i:s');
            } catch (Exception $e) {
                error_log("Date parsing error for site $siteId: " . $e->getMessage());
                // Keep 'N/A' as set in default response
            }
        }
    }
    
    echo json_encode($response);

} catch(Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'updated_time' => 'N/A',
        'update_by' => 'N/A'
    ]);
    error_log("Database error for site $siteId: " . $e->getMessage());
}
?>