<?php
require_once 'dompdf/autoload.inc.php';
use Dompdf\Dompdf;
use Dompdf\Options;

// Konfigurasi Dompdf agar bisa proses URL eksternal (jika nanti pakai gambar)
$options = new Options();
$options->set('isRemoteEnabled', true);

$dompdf = new Dompdf($options);

// Dummy Data OLT
$olt = [
    'name' => 'LW501',
    'doe' => 'LW501C2401',
    'brand' => 'Not Found',
    'poa' => 'LWS-OLT-01',
    'port_total' => 17,
    'port_used' => 14,
    'port_idle' => 3
];

// Generate 17 port
$ports = [];
for ($i = 1; $i <= 17; $i++) {
    $ports[] = [
        'number' => $i,
        'location' => "Area-$i"
    ];
}

ob_start();
?>

<!DOCTYPE html>
<html>
<head>
    <style>
        @page { margin: 0; }
        body {
            font-family: Arial, sans-serif;
            margin: 0;
        }

        .container {
            width: 210mm;
            height: 297mm;
            padding: 10mm;
            box-sizing: border-box;
        }

        .header {
            text-align: center;
            font-weight: bold;
            font-size: 18px;
            border-bottom: 2px solid #000;
            padding-bottom: 5px;
            margin-bottom: 5px;
        }

        .info-table, .coverage-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 10px;
            margin-top: 5px;
        }

        .info-table td, .info-table th, .coverage-table td, .coverage-table th {
            border: 1px solid #000;
            padding: 3px;
            text-align: center;
        }

        .section {
            margin-top: 10px;
        }

        .port-wrapper {
            display: flex;
            margin-bottom: 10px;
        }

        .port-column {
            width: 50%;
        }

        .port-box {
            border: 1px solid #444;
            margin: 1px;
            height: 18px;
            background-color: #ddd;
            text-align: center;
            font-size: 9px;
            line-height: 18px;
        }

        .diagram, .location-map {
            border: 1px solid #000;
            height: 80px;
            text-align: center;
            font-size: 10px;
            padding: 4px;
            margin-bottom: 8px;
        }

        .footer {
            margin-top: 12px;
            font-size: 10px;
            display: flex;
            justify-content: space-between;
        }

        .logo {
            height: 30px;
        }

        .signature {
            text-align: right;
            font-size: 10px;
        }

        .title-bar {
            background-color: #083;
            color: white;
            padding: 2px 6px;
            font-weight: bold;
            font-size: 11px;
            margin-bottom: 4px;
        }

    </style>
</head>
<body>
<div class="container">
    <div class="header">MICRO OLT</div>

    <!-- Info Table -->
    <table class="info-table">
        <tr>
            <th>OLT NAME</th>
            <th>OLT DOE</th>
            <th>OLT POA</th>
        </tr>
        <tr>
            <td><?= $olt['name'] ?></td>
            <td><?= $olt['doe'] ?></td>
            <td><?= $olt['poa'] ?></td>
        </tr>
    </table>

    <table class="info-table">
        <tr>
            <th>TYPE</th>
            <th>OLT DOE</th>
            <th>BRAND</th>
            <th>POA</th>
            <th>PORT</th>
            <th>USED</th>
            <th>IDLE</th>
        </tr>
        <tr>
            <td>GPON</td>
            <td><?= $olt['doe'] ?></td>
            <td><?= $olt['brand'] ?></td>
            <td><?= $olt['poa'] ?></td>
            <td><?= $olt['port_total'] ?></td>
            <td><?= $olt['port_used'] ?></td>
            <td><?= $olt['port_idle'] ?></td>
        </tr>
    </table>

    <!-- GPON PORT -->
    <div class="section">
        <div class="title-bar">GPON PORT</div>
        <div class="port-wrapper">
            <div class="port-column">
                <?php foreach (array_slice($ports, 0, ceil(count($ports)/2)) as $p): ?>
                    <div class="port-box"><?= $p['number'] ?></div>
                <?php endforeach; ?>
            </div>
            <div class="port-column">
                <?php foreach (array_slice($ports, ceil(count($ports)/2)) as $p): ?>
                    <div class="port-box"><?= $p['number'] ?></div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <!-- Logical Drawing -->
    <div class="section">
        <div class="title-bar">LOGICAL DRAWING</div>
        <div class="diagram">
            (Diagram kosong - gambar dinonaktifkan)
        </div>
    </div>

    <!-- Location -->
    <div class="section">
        <div class="title-bar">MICRO OLT LOCATION</div>
        <div class="location-map">(Peta lokasi kosong)</div>
    </div>

    <!-- Coverage Table -->
    <div class="section">
        <div class="title-bar">MICRO OLT COVERAGE</div>
        <table class="coverage-table">
            <tr>
                <th>NOTE</th><th>AREA NAME</th><th>PORT</th><th>ODC</th><th>JARAK</th><th>KETERANGAN</th>
            </tr>
            <?php for ($i = 1; $i <= 6; $i++): ?>
                <tr>
                    <td><?= $i ?></td>
                    <td>Area <?= $i ?></td>
                    <td><?= $i ?></td>
                    <td>ODC<?= $i ?></td>
                    <td><?= 90 + $i ?> m</td>
                    <td>-</td>
                </tr>
            <?php endfor; ?>
        </table>
    </div>

    <!-- Footer -->
    <div class="footer">
        <div class="logo">(Logo kosong)</div>
        <div class="signature">
            Approved by:<br>
            (Tanda tangan kosong)<br>
            <strong>Nama</strong>
        </div>
    </div>
</div>
</body>
</html>

<?php
$html = ob_get_clean();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("micro_olt.pdf", ["Attachment" => false]);
