<?php
require_once 'dbconfig.php';

$db = getDBConnection();

$editId = $_POST['editId'];
$siteid = $_POST['siteid'];
$slotid = $_POST['slotid'];
$merk = $_POST['merk'];

// Prepare port data
$portData = [];
for ($i = 0; $i <= 16; $i++) {
    $portData["port$i"] = isset($_POST["port$i"]) ? $_POST["port$i"] : 'unknown';
}

if (empty($editId)) {
    // Insert new record
    $columns = array_merge(['siteid', 'slotid', 'merk'], array_keys($portData), ['update_by', 'updated_time']);
    $values = array_merge([$siteid, $slotid, $merk], array_values($portData), ['admin', date('Y-m-d H:i:s')]);
    
    $placeholders = implode(',', array_fill(0, count($values), '?'));
    $query = "INSERT INTO port_management_olt (" . implode(',', $columns) . ") VALUES ($placeholders)";
} else {
    // Update existing record
    $setParts = [];
    $values = [];
    
    foreach ($portData as $key => $value) {
        $setParts[] = "$key = ?";
        $values[] = $value;
    }
    
    $values[] = $merk;
    $values[] = 'admin';
    $values[] = date('Y-m-d H:i:s');
    $values[] = $siteid;
    $values[] = $slotid;
    
    $query = "UPDATE port_management_olt SET merk = ?, " . implode(',', $setParts) . ", update_by = ?, updated_time = ? WHERE siteid = ? AND slotid = ?";
}

$stmt = $db->prepare($query);
$types = str_repeat('s', count($values)); // All parameters are treated as strings
$stmt->bind_param($types, ...$values);

if ($stmt->execute()) {
    echo json_encode(['status' => 'success']);
} else {
    echo json_encode(['status' => 'error', 'message' => $stmt->error]);
}

$stmt->close();
$db->close();
?>