<?php  
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}
$loggedInUser = $_SESSION['user'];
$fullName = $_SESSION['full_name'] ?? $loggedInUser;
require_once 'dbconfig.php'; 
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OLT Port Management</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet.fullscreen@2.4.0/Control.FullScreen.min.css" />
 
 <style>
    #portType, #portTypeBadge {
        display: none !important;
    }
    .leaflet-control-fullscreen {
        background-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="black" width="18px" height="18px"><path d="M0 0h24v24H0z" fill="none"/><path d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z"/></svg>');
        background-size: 70%;
        background-repeat: no-repeat;
        background-position: center;
    }

    .leaflet-control-fullscreen:hover {
        background-color: #f4f4f4;
    }

    .leaflet-container:-webkit-full-screen {
        width: 100% !important;
        height: 100% !important;
    }
    
 
       /* Custom CSS for vertical slots and horizontal ports */
        .slot-container {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        
        .slot-row {
            display: flex;
            gap: 10px;
            align-items: flex-start;
        }
        
        .slot-header {
            background-color: #f8f9fa;
            padding: 5px 10px;
            border-radius: 4px;
            font-weight: bold;
            text-align: center;
            margin-bottom: 5px;
        }
        
        .port-container {
            display: flex;
            flex-wrap: wrap;
            gap: 5px;
            padding: 5px;
            background-color: #f1f1f1;
            border-radius: 4px;
        }
        
        .port-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            cursor: pointer;
            padding: 5px;
            border-radius: 4px;
            transition: all 0.2s;
        }
        
        .port-item:hover {
            background-color: #e9ecef;
        }
        
        .port-circle {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: #fff;
            border: 1px solid #dee2e6;
            margin-bottom: 3px;
            font-size: 12px;
        }
        
        .port-used .port-circle {
            background-color: #d1e7dd;
            border-color: #badbcc;
        }
        
        .port-unused .port-circle {
            background-color: #f8d7da;
            border-color: #f5c2c7;
        }
        
        .fdt-badge {
            font-size: 10px;
            padding: 2px 5px;
            border-radius: 3px;
            color: white;
            text-align: center;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            min-width: 80px;
            max-width: 80px;
            min-height: 30px;
            max-height: 30px;
        }
        
        .fdt-badge.RFS {
            background-color: #198754;
        }
        
        .fdt-badge.Construction {
            background-color: #fd7e14;
        }
        
        .fdt-badge.Design {
            background-color: #0dcaf0;
        }
        
        .fdt-badge.Unused {
            background-color: #6c757d;
        }
    
    /* Rest of the existing CSS */
    .select2-container--disabled .select2-selection {
        background-color: #f8f9fa;
        cursor: not-allowed;
    }
    
    .select2-results__option--loading {
        color: #6c757d;
        font-style: italic;
    }
    
    #summaryContainer .card {
        height: 100%;
        transition: transform 0.2s;
    }
    
    #summaryContainer .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    
    #summaryContainer .card-title {
        font-size: 1rem;
        margin-bottom: 0.5rem;
    }
    
    #summaryContainer .card-text {
        font-weight: bold;
        margin-bottom: 0;
    }
    
    .port-status-badge {
        width: 20px;
        height: 20px;
        border-radius: 3px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        margin-right: 8px;
        flex-shrink: 0;
        color: white;
        font-size: 0.65rem;
    }
    
    .card-header.py-2 {
        padding-top: 0.5rem;
        padding-bottom: 0.5rem;
    }
    
    .port-status-badge.RFS {
        background-color: #28a745;
    }
    
    .port-status-badge.Construction {
        background-color: #ffc107;
        color: #212529;
    }
    
    .port-status-badge.Planning {
        background-color: #6f42c1;
    }
    
    .port-status-badge.Design {
        background-color: #2b66cd;
    }
    
    .port-status-badge.Unused {
        background-color: #6c757d;
    }
    
    .port-status-badge.Used {
        background-color: #dc3545;
    }
    
    /* Rectangular Port Indicator Styles */
    .port-rect {
        width: 20px;
        height: 12px;
        display: inline-block;
        border-radius: 2px;
        background-color: #e9ecef;
    }
    
    /* Status Colors */
    .port-rect.port-used {
        background-color: #dc3545;
    }
    
    .port-rect.port-unused {
        background-color: #787d7a;
    }
    
    .port-rect.RFS {
        background-color: #28a745;
    }
    
    .port-rect.Construction {
        background-color: #ffc107;
    }
    
    .port-rect.Planning {
        background-color: #6f42c1;
    }
    
    .port-rect.Design {
        background-color: #2b66cd;
    }
    
    /* Card Layout Styles */
    .card[style*="width: 450px"] {
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        border-radius: 8px;
    }
    
    .card-header.py-2 {
        padding: 0.5rem 1rem;
    }
    
    .card-body {
        padding: 1rem;
    }
    
    /* Summary Box Styles */
    .border.rounded {
        border: 1px solid #dee2e6;
        border-radius: 6px !important;
        background-color: #f8f9fa;
    }
    
    /* Text Styles */
    .card[style*="width: 450px"] h5 {
        font-size: 1.1rem;
        font-weight: 600;
        margin: 0.2rem 0;
    }
    
    .card[style*="width: 450px"] small {
        font-size: 0.7rem;
        line-height: 1.3;
    }
    
    /* Spacing */
    .mb-2 {
        margin-bottom: 0.5rem !important;
    }
    
    .g-2 {
        gap: 0.5rem !important;
    }
    
    .port-rect {
        display: inline-block;
        border-radius: 2px;
    }
    
    .RFS { background-color: #28a745; }
    .Construction { background-color: #ffc107; }
    .Design { background-color: #2b66cd; }
    .Planning { background-color: #6f42c1; }
    .Unused { background-color: #6c757d; }
    
    /* Select2 Styles */
    .select2-container {
        width: 100% !important;
    }
    
    .select2-selection {
        border: 1px solid #ced4da !important;
        height: 38px !important;
        padding: 6px 12px !important;
    }
    
    .select2-selection__arrow {
        height: 36px !important;
    }
    
    .select2-selection, .select2-dropdown {
        border-radius: 4px !important;
    }
    
    @media (min-width: 768px) {
        .col-md-5 {
            max-width: 450px;
        }
    }
    
    /* Badge Styles */
    .badge-merk {
        font-size: 0.8rem;
        padding: 0.35em 0.65em;
        background-color: #17a2b8;
        margin-left: 0.5rem;
    }
    
    /* Slot Header */
    .slot-header {
        font-weight: bold;
        margin-bottom: 10px;
        font-size: 1.1rem;
        text-align: center;
        text-transform: uppercase;
    }
    
    /* Responsive Adjustments */
    @media print {
        .olt-container-a4 {
            box-shadow: none;
            padding: 0;
        }
    }
</style>
 
</head>
<body>
<!-- Modify the container div -->
<div class="container-fluid py-3">
    <div class="row mb-4 justify-content-center"> 
        <!-- Added justify-content-center -->
        <div class="col-md-5">
            <h5>OLT Port Management</h5>
        </div>
    </div>

    <div class="row mb-3 justify-content-center"> 
        <!-- Added justify-content-center -->
        <div class="col-md-5">  <!-- Changed from col-md-3 to col-md-5 -->
            <select class="form-select select2" id="citySelect" style="max-width: 100%">  <!-- Added max-width -->
                <option value="">Silahkan Pilih Kota</option>
                <?php
                $db = getDBConnection();
                $cities = $db->query("SELECT DISTINCT kota FROM assetdata WHERE jenis2 = 'MICRO' ORDER BY kota");
                while ($city = $cities->fetch_assoc()) {
                    echo '<option value="'.htmlspecialchars($city['kota']).'">'
                        .htmlspecialchars($city['kota']).'</option>';
                }
                $db->close();
                ?>
            </select>
        </div>
        <div class="col-md-5">  <!-- Changed from col-md-3 to col-md-5 -->
            <select class="form-select select2" id="siteSelect" disabled style="max-width: 100%">  <!-- Added max-width -->
                <option value="">Silahkan Pilih OLT</option>
            </select>
        </div>
    </div>

    <!-- Changed this div to use olt-container-a4 class -->
    <div class="olt-container-a4 card mb-3" id="oltContainer" style="display:none;">
        <div class="card-body p-3">
            <h6 id="oltTitle" class="mb-3"></h6>
            
            <!-- Slot Container (now full width) -->
            <div class="slot-container" id="slotContainer"></div>
            <br>
            
            <!-- Information Row (row 2) - Split into 2 columns -->
            <div class="row info-row">
                <!-- Left Column (OLT Location) - Takes remaining space -->
                <div class="col" style="padding-right: 20px;">
                    <div class="card mb-3">
                        <div class="card-header py-2">
                            <h6 class="mb-0" style="font-size: 0.9rem;">OLT Location</h6>
                        </div>
                        <div class="card-body p-0">
                            <div id="oltMap" style="height: 400px;"></div>
                        </div>
                    </div>
                </div>
                
                <!-- Right Column (Port Summary, Legend, Document Info) - Fixed 400px width -->
                <div style="width: 400px; flex-shrink: 0;">
                    <!-- Port Summary Card -->
                    <div class="card mb-3">
                        <div class="card-header bg-primary text-white py-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="mb-0" style="font-size: 0.9rem;">Port Summary</h6>
                                <small id="portType" style="font-size: 0.75rem;">HUAWEI 0-15</small>
                            </div>
                        </div>
                        
                        <div class="card-body p-2">
                            <!-- Summary Section -->
                            <div class="d-flex justify-content-between mb-3">
                                <div class="text-center" style="width: 23%;">
                                    <div class="border rounded p-1">
                                        <small class="text-muted d-block" style="font-size: 0.65rem;">Total</small>
                                        <h5 id="totalPorts" class="mb-0" style="font-size: 0.9rem;">0</h5>
                                        <small class="text-muted d-block" id="portTypeBadge" style="font-size: 0.6rem;">HUAWEI</small>
                                    </div>
                                </div>
                                <div class="text-center" style="width: 23%;">
                                    <div class="border rounded p-1">
                                        <small class="text-success d-block" style="font-size: 0.65rem;">RFS</small>
                                        <h5 id="rfsPorts" class="mb-0" style="font-size: 0.9rem;">0</h5>
                                    </div>
                                </div>
                                <div class="text-center" style="width: 23%;">
                                    <div class="border rounded p-1">
                                        <small class="text-warning d-block" style="font-size: 0.65rem;">Non-RFS</small>
                                        <h5 id="nonRfsPorts" class="mb-0" style="font-size: 0.9rem;">0</h5>
                                    </div>
                                </div>
                                <div class="text-center" style="width: 23%;">
                                    <div class="border rounded p-1">
                                        <small class="text-secondary d-block" style="font-size: 0.65rem;">Available</small>
                                        <h5 id="unusedPorts" class="mb-0" style="font-size: 0.9rem;">0</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Legend Card -->
                    <div class="card mb-3">
                        <div class="card-header bg-primary text-white py-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="mb-0" style="font-size: 0.9rem;">Legend</h6>
                                <small id="portType" style="font-size: 0.75rem;">HUAWEI 0-15</small>
                            </div>
                        </div>
                        
                        <div class="card-body p-2">
                            <div class="border-top pt-2 mb-3">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="d-flex align-items-center mb-1">
                                            <span class="port-rect RFS me-1" style="width: 16px; height: 10px;"></span>
                                            <small style="font-size: 0.65rem;">RFS</small>
                                        </div>
                                        <div class="d-flex align-items-center mb-1">
                                            <span class="port-rect Construction me-1" style="width: 16px; height: 10px;"></span>
                                            <small style="font-size: 0.65rem;">Construction</small>
                                        </div>
                                        <div class="d-flex align-items-center mb-1">
                                            <span class="port-rect Design me-1" style="width: 16px; height: 10px;"></span>
                                            <small style="font-size: 0.65rem;">Design</small>
                                        </div>
                                        <div class="d-flex align-items-center mb-1">
                                            <span class="port-rect Planning me-1" style="width: 16px; height: 10px;"></span>
                                            <small style="font-size: 0.65rem;">Planning</small>
                                        </div>
                                        <div class="d-flex align-items-center mb-1">
                                            <span class="port-rect Unused me-1" style="width: 16px; height: 10px;"></span>
                                            <small style="font-size: 0.65rem;">Available</small>
                                        </div>
                                    </div>
                                    <div class="col-6 text-center">
                                        <!-- Logo dari URL -->
                                        <img src="https://www.linknet.co.id/files/logo-ln-terbaru.png" 
                                         style="max-height: 80px; max-width: 100%; object-fit: contain;">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Document Information Card -->
                    <div class="card">
                        <div class="card-header bg-primary text-white py-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="mb-0" style="font-size: 0.9rem;">Document Information</h6>
                                <small id="portType" style="font-size: 0.75rem;">HUAWEI 0-15</small>
                            </div>
                        </div>
                        
                        <div class="card-body p-2">
                            <!-- Information Section -->
                            <div class="border-top pt-2">
                                <div class="d-flex justify-content-between align-items-start mb-2">
                                    <div style="width: 45%;">
                                        <small class="text-muted" style="font-size: 0.75rem; font-weight: 500;">LAST MODIFIED</small>
                                    </div>
                                    <div style="width: 55%; text-align: right;">
                                        <div id="lastModifiedDate" style="font-size: 0.8rem; font-weight: 500;">Loading...</div>
                                        <div id="lastModifiedBy" style="font-size: 0.75rem; color: #6c757d;">Loading...</div>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between align-items-start mb-2">
                                    <div style="width: 45%;">
                                        <small class="text-muted" style="font-size: 0.75rem; font-weight: 500;">RELEASE INFO</small>
                                    </div>
                                    <div style="width: 55%; text-align: right;">
                                        <div id="releaseDate" style="font-size: 0.8rem; font-weight: 500;"><?php
date_default_timezone_set('Asia/Jakarta');
echo date('Y-m-d');
?></div>
                                        <div id="releaseBy" style="font-size: 0.75rem; color: #6c757d;"><?php echo htmlspecialchars($fullName); ?></div>
                                    </div>
                                </div>
                                
                                <div class="d-flex justify-content-between align-items-center pt-2" style="border-top: 1px solid #dee2e6;">
                                    <div style="width: 45%;">
                                        <small class="text-muted" style="font-size: 0.75rem; font-weight: 500;">INDEX DRAWING</small>
                                    </div>
                                    <div style="width: 55%; text-align: right;">
                                        <div id="indexDrawing" style="font-size: 0.8rem; font-weight: 500; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;" title="Loading...">Loading...</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Edit Port -->
<div class="modal fade" id="portModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalTitle">Port Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="portForm">
            <input type="hidden" id="modalSiteId">
            <input type="hidden" id="modalSlotId">
            <input type="hidden" id="modalPortNum">
            <div class="mb-3">
                <label class="form-label">OLT Merk</label>
                <input type="text" class="form-control" id="modalOltMerk" readonly>
            </div>
            <div class="mb-3">
                <label class="form-label">FDT</label>
                <input type="text" class="form-control" id="modalFdtCode" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Updated By</label>
               <input type="text" class="form-control" id="modalUpdateBy" value="<?= htmlspecialchars($loggedInUser) ?>" readonly>
            </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary" id="savePortBtn">Save</button>
      </div>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/leaflet.fullscreen@2.4.0/Control.FullScreen.min.js"></script>
<script type="module">
    // Import the modules
    import { loadModificationData } from './modificationData.js';
    import { createMapModule } from './mapModule.js';

    // Global variables
    let currentSite = '';
    let currentSlot = 0;
    let currentPort = 0;
    const portModal = new bootstrap.Modal('#portModal');
    
    // Initialize map module
    const mapModule = createMapModule('oltMap');
    
    // Initialize Select2 dropdowns
    $(document).ready(function() {
        $('#citySelect').select2({
            placeholder: "Pilih Kota",
            allowClear: true,
            width: '100%'
        });
        
        $('#siteSelect').select2({
            placeholder: "Pilih Micro OLT",
            allowClear: true,
            width: '100%'
        });
    });
    
    // Initialize event listeners
    $('#citySelect').on('change', loadOLTSites);
    $('#siteSelect').on('change', loadOLT);
    document.getElementById('savePortBtn').addEventListener('click', savePort);

    // Load OLT sites based on selected city
    function loadOLTSites() {
        const city = this.value;
        const siteSelect = $('#siteSelect');
        
        if (!city) {
            siteSelect.prop('disabled', true).val('').trigger('change');
            $('#oltContainer').hide();
            return;
        }
        
        // Show loading state
        siteSelect.prop('disabled', true).html('<option value="">Loading...</option>');
        
        fetch(`get_olts.php?city=${encodeURIComponent(city)}`)
            .then(response => response.json())
            .then(data => {
                siteSelect.empty().append('<option value="">Select OLT Site</option>');
                
                data.forEach(olt => {
                    const option = new Option(olt.siteid, olt.siteid);
                    $(option).data('status', olt.status || 'Unused')
                            .data('merk', olt.merk || 'Unknown');
                    siteSelect.append(option);
                });
                
                siteSelect.prop('disabled', false).trigger('change');
            })
            .catch(error => {
                console.error('Error loading OLTs:', error);
                siteSelect.empty().append('<option value="">Error loading data</option>');
            });
    }
    
    // Load OLT data
    async function loadOLT() {
        currentSite = this.value;
        const selectedOption = $(this).find('option:selected');
        const siteStatus = selectedOption.data('status') || 'Unused';
        const siteMerk = selectedOption.data('merk') || 'Unknown';
        
        if (!currentSite) {
            document.getElementById('oltContainer').style.display = 'none';
            return;
        }
        
        // Update title
        document.getElementById('oltTitle').innerHTML = `
            <span class="fdt-badge ${siteStatus}">${currentSite}</span>
            <span class="fdt-badge ${siteStatus}">${siteMerk}</span>
        `;
        document.getElementById('oltContainer').style.display = 'block';
        
        try {
            const response = await fetch(`get_slots.php?siteid=${encodeURIComponent(currentSite)}`);
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            
            const data = await response.json();
            
            if (!data.success) {
                throw new Error(data.error || 'Failed to load OLT data');
            }
            
            renderSlots(data.slots, data.stats.merk);
            updateSummaryCard(data.stats);
            
            // Load location data separately
            try {
                const locationResponse = await fetch(`get_location.php?siteid=${encodeURIComponent(currentSite)}`);
                if (locationResponse.ok) {
                    const locationData = await locationResponse.json();
                    mapModule.showLocation(locationData, currentSite);
                }
            } catch (locationError) {
                console.error('Error loading location:', locationError);
            }
            
            // Load modification data
            const modData = await loadModificationData(currentSite);
            document.getElementById('lastModifiedDate').textContent = modData.lastModifiedDate;
            document.getElementById('lastModifiedBy').textContent = modData.lastModifiedBy;
            document.getElementById('indexDrawing').textContent = modData.indexDrawing;
            document.getElementById('indexDrawing').setAttribute('title', modData.indexDrawing);
            
        } catch (error) {
            console.error('Error loading OLT:', error);
            alert('Error loading OLT data: ' + error.message);
        }
    }

    function renderSlots(slotsData, merk) {
        const slotContainer = document.getElementById('slotContainer');
        slotContainer.innerHTML = '';

        const slotNumbers = Object.keys(slotsData).map(Number).sort((a, b) => a - b);
        
        if (slotNumbers.length === 0) {
            slotContainer.innerHTML = '<div class="alert alert-info">No slots found for this OLT</div>';
            return;
        }

        const portRange = (merk === 'ZTE') ? 
            Array.from({length: 16}, (_, i) => i + 1) : // ZTE: 1-16
            Array.from({length: 16}, (_, i) => i);     // HUAWEI: 0-15

        slotNumbers.forEach(slotNum => {
            const slotDiv = document.createElement('div');
            slotDiv.className = 'slot-wrapper';
            
            const slotHeader = document.createElement('div');
            slotHeader.className = 'slot-header';
            slotHeader.textContent = `Slot ${slotNum}`;
            slotDiv.appendChild(slotHeader);

            const portContainer = document.createElement('div');
            portContainer.className = 'port-container';
            
            const slotData = slotsData[slotNum];
            
            portRange.forEach(portNum => {
                const portKey = `port${portNum}`;
                const statusKey = `status${portNum}`;
                const portValue = slotData[portKey] || 'Unused';
                const status = slotData[statusKey] || 'Unused';
                const isUsed = portValue !== 'Unused';

                const portDiv = document.createElement('div');
                portDiv.className = `port-item ${isUsed ? 'port-used' : 'port-unused'}`;
                
                let formattedValue = portValue;
                if (portValue.length > 6) {
                    formattedValue = portValue.match(/.{1,6}/g).join('<br>');
                }
                
                portDiv.innerHTML = `
                    <div class="port-circle">${portNum}</div>
                    <div class="port-info">
                        <div class="fdt-badge ${status}" style="white-space: normal; line-height: 1.2;">${formattedValue}</div>
                    </div>
                `;

                portDiv.addEventListener('click', () => {
                    selectPort(slotNum, portNum);
                });

                portContainer.appendChild(portDiv);
            });

            slotDiv.appendChild(portContainer);
            slotContainer.appendChild(slotDiv);
        });
    }

    function updateSummaryCard(stats) {
        const total = stats.total || 0;
        const rfs = stats.rfs || 0;
        const nonRfs = stats.non_rfs || 0;
        const unused = stats.unused || 0;
        const merk = stats.merk || 'HUAWEI';
        
        document.getElementById('totalPorts').textContent = total;
        document.getElementById('rfsPorts').textContent = rfs;
        document.getElementById('nonRfsPorts').textContent = nonRfs;
        document.getElementById('unusedPorts').textContent = unused;
        document.getElementById('portType').textContent = `${merk} ${merk === 'ZTE' ? '1-16' : '0-15'}`;
        document.getElementById('portTypeBadge').textContent = merk;
    }
    
    async function selectPort(slotNum, portNum) {
        currentSlot = slotNum;
        currentPort = portNum;
        
        const selectedOption = $('#siteSelect').find('option:selected');
        const siteMerk = selectedOption.data('merk') || 'HUAWEI';
        
        let minPort, maxPort;
        if (siteMerk === 'ZTE') {
            minPort = 1; maxPort = 16;
        } else {
            minPort = 0; maxPort = 15;
        }
        
        if (portNum < minPort || portNum > maxPort) {
            alert(`Invalid port number for ${siteMerk}. Valid range: ${minPort}-${maxPort}`);
            return;
        }
        
        try {
            const response = await fetch(`get_port.php?siteid=${currentSite}&slotid=${slotNum}&port=${portNum}&merk=${siteMerk}`);
            const portData = await response.json();
            
            document.getElementById('modalTitle').textContent = 
                `${siteMerk} Port ${portNum} - Slot ${slotNum}`;
            document.getElementById('modalSiteId').value = currentSite;
            document.getElementById('modalSlotId').value = slotNum;
            document.getElementById('modalPortNum').value = portNum;
            document.getElementById('modalOltMerk').value = siteMerk;
            document.getElementById('modalFdtCode').value = portData.fdt_code || '';
            
            portModal.show();
        } catch (error) {
            console.error('Error loading port:', error);
            alert(`Error loading port details: ${error.message}`);
        }
    }
    
    async function savePort() {
        const portData = {
            siteid: document.getElementById('modalSiteId').value,
            slotid: parseInt(document.getElementById('modalSlotId').value),
            port: parseInt(document.getElementById('modalPortNum').value),
            fdt_code: document.getElementById('modalFdtCode').value,
            update_by: document.getElementById('modalUpdateBy').value,
            merk: document.getElementById('modalOltMerk').value
        };

        try {
            const response = await fetch('update_port.php', {
                method: 'POST',
                headers: { 
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(portData)
            });

            const text = await response.text();
            let result;
            try {
                result = JSON.parse(text);
            } catch (e) {
                throw new Error(`Invalid JSON response: ${text}`);
            }

            if (!response.ok) {
                throw new Error(result.error || `Server error: ${response.status}`);
            }

            if (result.success) {
                portModal.hide();
                loadOLT.call({ value: currentSite });
                alert('Port updated successfully!');
            } else {
                throw new Error(result.error || 'Failed to save port');
            }
        } catch (error) {
            console.error('Full error:', error);
            alert(`Error: ${error.message}`);
        }
    }
</script>
</body>
</html>