<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Asset Data Management</title>
    
    <!-- CSS Libraries -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        .modal-dialog {
            max-width: 800px;
        }
        .dataTables_wrapper .dataTables_filter {
            float: right;
        }
        .dataTables_wrapper .dataTables_length {
            float: left;
        }
        .btn-action {
            min-width: 80px;
            margin: 2px;
        }
        .error-message {
            color: red;
            font-size: 0.9em;
        }
    </style>
</head>
<body>
    <div class="container-fluid mt-4">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <div class="d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">Asset Data Management</h3>
                    <button class="btn btn-light" onclick="showAddModal()">
                        <i class="fas fa-plus"></i> Add New Asset
                    </button>
                </div>
            </div>
            <div class="card-body">
                <table id="assetTable" class="table table-striped table-bordered nowrap" style="width:100%">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Kota</th>
                            <th>Site ID</th>
                            <th>Name</th>
                            <th>Latitude</th>
                            <th>Longitude</th>
                            <th>Jenis</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add/Edit Modal -->
    <div class="modal fade" id="assetModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTitle">Add New Asset</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="assetForm" novalidate>
                        <input type="hidden" id="assetId">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="kota" class="form-label">Kota*</label>
                                <input type="text" class="form-control" id="kota" required>
                                <div class="invalid-feedback">Please provide a kota.</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="siteid" class="form-label">Site ID*</label>
                                <input type="text" class="form-control" id="siteid" required>
                                <div class="invalid-feedback">Please provide a site ID.</div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="name" class="form-label">Name*</label>
                                <input type="text" class="form-control" id="name" required>
                                <div class="invalid-feedback">Please provide a name.</div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="lat" class="form-label">Latitude*</label>
                                <input type="text" class="form-control" id="lat" required>
                                <div class="invalid-feedback">Please provide latitude.</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="lng" class="form-label">Longitude*</label>
                                <input type="text" class="form-control" id="lng" required>
                                <div class="invalid-feedback">Please provide longitude.</div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="jenis" class="form-label">Jenis*</label>
                                <input type="text" class="form-control" id="jenis" required>
                                <div class="invalid-feedback">Please provide jenis.</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="status" class="form-label">Status*</label>
                                <select class="form-select" id="status" required>
                                    <option value="">Select Status</option>
                                    <option value="Active">Active</option>
                                    <option value="Inactive">Inactive</option>
                                    <option value="Maintenance">Maintenance</option>
                                </select>
                                <div class="invalid-feedback">Please select status.</div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" onclick="saveAsset()">Save Changes</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title">Confirm Delete</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to delete this asset? This action cannot be undone.</p>
                    <input type="hidden" id="deleteId">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" onclick="confirmDelete()">Delete</button>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.7.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>

    <script>
        // Global variables
        let assetTable;
        let assetModal;
        let deleteModal;
        
        $(document).ready(function() {
            // Initialize modals
            assetModal = new bootstrap.Modal(document.getElementById('assetModal'));
            deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
            
            // Initialize DataTable
            assetTable = $('#assetTable').DataTable({
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ],
                ajax: {
                    url: 'dbcrud.php',
                    dataSrc: 'data',
                    error: function(xhr, error, thrown) {
                        console.error('DataTables error:', xhr.responseText);
                        showErrorAlert('Failed to load data. Please check console for details.');
                    }
                },
                columns: [
                    { data: 'id' },
                    { data: 'kota' },
                    { data: 'siteid' },
                    { data: 'name' },
                    { data: 'lat' },
                    { data: 'lng' },
                    { data: 'jenis' },
                    { data: 'status' },
                    {
                        data: null,
                        render: function(data, type, row) {
                            return `
                                <div class="btn-group">
                                    <button class="btn btn-sm btn-warning btn-action" onclick="editAsset(${row.id})">
                                        <i class="fas fa-edit"></i> Edit
                                    </button>
                                    <button class="btn btn-sm btn-danger btn-action" onclick="showDeleteModal(${row.id})">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>
                                </div>
                            `;
                        },
                        orderable: false,
                        searchable: false
                    }
                ],
                responsive: true,
                processing: true,
                serverSide: false,
                language: {
                    processing: '<i class="fa fa-spinner fa-spin fa-3x fa-fw"></i><span class="sr-only">Loading...</span>',
                    emptyTable: 'No data available in table',
                    info: 'Showing _START_ to _END_ of _TOTAL_ entries',
                    infoEmpty: 'Showing 0 to 0 of 0 entries',
                    infoFiltered: '(filtered from _MAX_ total entries)',
                    lengthMenu: 'Show _MENU_ entries',
                    search: 'Search:',
                    zeroRecords: 'No matching records found'
                }
            });
            
            // Form validation
            const form = document.getElementById('assetForm');
            form.addEventListener('submit', function(event) {
                event.preventDefault();
                event.stopPropagation();
                if (form.checkValidity()) {
                    saveAsset();
                }
                form.classList.add('was-validated');
            }, false);
        });
        
        function showAddModal() {
            $('#modalTitle').text('Add New Asset');
            $('#assetForm')[0].reset();
            $('#assetId').val('');
            $('#assetForm').removeClass('was-validated');
            assetModal.show();
        }
        
        function editAsset(id) {
            $.ajax({
                url: `dbcrud.php?id=${id}`,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#modalTitle').text('Edit Asset');
                    $('#assetId').val(data.id);
                    $('#kota').val(data.kota);
                    $('#siteid').val(data.siteid);
                    $('#name').val(data.name);
                    $('#lat').val(data.lat);
                    $('#lng').val(data.lng);
                    $('#jenis').val(data.jenis);
                    $('#status').val(data.status);
                    $('#assetForm').removeClass('was-validated');
                    assetModal.show();
                },
                error: function(xhr) {
                    console.error('Error fetching asset:', xhr.responseText);
                    showErrorAlert('Failed to load asset data. Please check console for details.');
                }
            });
        }
        
        function saveAsset() {
            const id = $('#assetId').val();
            const assetData = {
                kota: $('#kota').val(),
                siteid: $('#siteid').val(),
                name: $('#name').val(),
                lat: $('#lat').val(),
                lng: $('#lng').val(),
                jenis: $('#jenis').val(),
                status: $('#status').val()
            };
            
            if (id) {
                // Update existing asset
                assetData.id = id;
                $.ajax({
                    url: 'dbcrud.php',
                    type: 'PUT',
                    contentType: 'application/json',
                    data: JSON.stringify(assetData),
                    success: function() {
                        assetTable.ajax.reload();
                        assetModal.hide();
                        showSuccessAlert('Asset updated successfully!');
                    },
                    error: function(xhr) {
                        console.error('Error updating asset:', xhr.responseText);
                        showErrorAlert('Failed to update asset. Please check console for details.');
                    }
                });
            } else {
                // Add new asset
                $.ajax({
                    url: 'dbcrud.php',
                    type: 'POST',
                    contentType: 'application/json',
                    data: JSON.stringify(assetData),
                    success: function() {
                        assetTable.ajax.reload();
                        assetModal.hide();
                        showSuccessAlert('Asset added successfully!');
                    },
                    error: function(xhr) {
                        console.error('Error adding asset:', xhr.responseText);
                        showErrorAlert('Failed to add asset. Please check console for details.');
                    }
                });
            }
        }
        
        function showDeleteModal(id) {
            $('#deleteId').val(id);
            deleteModal.show();
        }
        
        function confirmDelete() {
            const id = $('#deleteId').val();
            $.ajax({
                url: `dbcrud.php?id=${id}`,
                type: 'DELETE',
                success: function() {
                    assetTable.ajax.reload();
                    deleteModal.hide();
                    showSuccessAlert('Asset deleted successfully!');
                },
                error: function(xhr) {
                    console.error('Error deleting asset:', xhr.responseText);
                    showErrorAlert('Failed to delete asset. Please check console for details.');
                }
            });
        }
        
        function showSuccessAlert(message) {
            const alert = $(`
                <div class="alert alert-success alert-dismissible fade show position-fixed top-0 end-0 m-3" role="alert" style="z-index: 9999">
                    ${message}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            `);
            $('body').append(alert);
            setTimeout(() => alert.alert('close'), 3000);
        }
        
        function showErrorAlert(message) {
            const alert = $(`
                <div class="alert alert-danger alert-dismissible fade show position-fixed top-0 end-0 m-3" role="alert" style="z-index: 9999">
                    ${message}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            `);
            $('body').append(alert);
            setTimeout(() => alert.alert('close'), 5000);
        }
    </script>
</body>
</html>