<?php
require_once 'dbconfig.php';

header('Content-Type: application/json');

$db = getDBConnection();
$data = json_decode(file_get_contents('php://input'), true);

$siteid = $db->real_escape_string($data['siteid']);
$slotid = intval($data['slotid']);

// Validate
if (empty($siteid)) {
    echo json_encode(['success' => false, 'error' => 'Site ID is required']);
    exit;
}

if ($slotid < 0 || $slotid > 14) {
    echo json_encode(['success' => false, 'error' => 'Invalid slot number']);
    exit;
}

// Check if exists
$result = $db->query("SELECT 1 FROM port_management_olt WHERE siteid = '$siteid' AND slotid = $slotid");
if ($result->num_rows > 0) {
    echo json_encode(['success' => false, 'error' => 'Slot already exists']);
    exit;
}

// Create new slot
$columns = ['siteid', 'slotid'];
$values = ["'$siteid'", $slotid];

for ($i = 1; $i <= 16; $i++) {
    $columns[] = "port$i";
    $values[] = "'Unused'";
}

$query = "INSERT INTO port_management_olt (".implode(',', $columns).") VALUES (".implode(',', $values).")";

if ($db->query($query)) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'error' => $db->error]);
}

$db->close();
?>