<?php
require_once 'dbconfig.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Invalid request method']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$siteid = $data['siteid'] ?? '';

if (empty($siteid)) {
    echo json_encode(['success' => false, 'error' => 'Site ID is required']);
    exit;
}

try {
    $db = getDBConnection();
    
    // Check if OLT already exists
    $stmt = $db->prepare("SELECT siteid FROM ports WHERE siteid = ? LIMIT 1");
    $stmt->bind_param("s", $siteid);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        echo json_encode(['success' => false, 'error' => 'OLT already exists']);
        exit;
    }
    
    // Insert default slot (slot 1) for the new OLT
    $slotid = 1; // Default slot ID set to 1
    $stmt = $db->prepare("INSERT INTO ports (siteid, slotid) VALUES (?, ?)");
    $stmt->bind_param("si", $siteid, $slotid);
    
    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => $db->error]);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}